unit ThreadDemoForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ThrdMessaged, TrdSynchronized, ThrdServer;

type
  TForm1 = class(TForm)
    BtnUnSafe: TButton;
    BtnProgramThread: TButton;
    BtnRunOnce: TButton;
    MmoResults: TMemo;
    BtnRunServerThrd: TButton;
    BtnSyncRtn: TButton;
    procedure BtnUnSafeClick(Sender: TObject);
    procedure BtnProgramThreadClick(Sender: TObject);
    procedure BtnRunOnceClick(Sender: TObject);
    procedure BtnRunServerThrdClick(Sender: TObject);
    procedure BtnSyncRtnClick(Sender: TObject);
  private
    { Private declarations }
    FUnsafeArray: array[0..3] of char;
    FUnsafeLoc: integer;
    FServerThread: TMessageRtnThread;
    FSyncThread: TSyncRtnThread;
    procedure RunOnceTerminate(Sender: TObject);
    procedure MessageHandler(var AMessage: TMessage); message AM_ThreadReturn;
    procedure ServerObjectReturn(AServerObj: TSrverTaskObj);
    procedure SynchObjectReturn;
  public
    { Public declarations }
    destructor destroy;override;

  end;

var
  Form1: TForm1;
const
  AppCommandLine = '.\ConsoleApp\ConsoleThread.exe';

implementation

uses TrdSingleRun, IBAccess;

{$R *.dfm}

procedure TForm1.BtnProgramThreadClick(Sender: TObject);
var
  SI: TStartupInfo;
  PI: TProcessInformation;

begin
  FillChar(SI, SizeOf(SI), 0);
  SI.cb := SizeOf(SI);
  SI.wShowWindow := SW_SHOWDEFAULT;
  if not CreateProcess(nil, PChar(AppCommandLine), nil, nil, True,
    NORMAL_PRIORITY_CLASS + DETACHED_PROCESS, nil, nil, SI, PI) then
    raise Exception.Create('Failed to execute program.  :: ' + IntToStr(GetLastError));

end;

procedure TForm1.BtnRunOnceClick(Sender: TObject);
var
  ThrdObj: TSingleRunThread;

begin
  ThrdObj := TSingleRunThread.Create(True);
  try
    ThrdObj.DbQuery := DbQueryConstant;
    ThrdObj.OnTerminate := RunOnceTerminate;
    ThrdObj.Resume;
  except
    ThrdObj.Free;
  end;
end;

procedure TForm1.BtnRunServerThrdClick(Sender: TObject);
var
  i: integer;
  NxtTask: TSrverTaskObj;
begin
  if FServerThread = nil then
    FServerThread := TMessageRtnThread.Create;
  for i := 1 to 20 do
  begin
    NxtTask := TSrverTaskObj.Create;
    NxtTask.SqlCommand := 'Select * from salary_History Where Emp_no<' + intToStr(i);
    NxtTask.FmHandle := Handle;
    FServerThread.Push(NxtTask);
  end;
end;

procedure TForm1.BtnUnSafeClick(Sender: TObject);
  function GetChar: Char;      //Pretend Thread
  begin
  if Random(25)>20 then
    FUnsafeLoc := 2 * FUnsafeLoc;
    Result := Char(Ord('A') + FUnsafeLoc);
  end;
begin
  FUnsafeLoc := 3;
  FUnsafeArray[FUnsafeLoc] := GetChar;
end;

destructor TForm1.destroy;
begin
  FServerThread.Free;
  FSyncThread.Free;
  inherited;
end;

procedure TForm1.MessageHandler(var AMessage: TMessage);
begin
  case AMessage.WParam of
    AM_Type_ServerObj: ServerObjectReturn(Pointer(AMessage.LParam))
  end; //case
end;

procedure TForm1.RunOnceTerminate(Sender: TObject);
var
  ThrdObj: TSingleRunThread;
  ResultArray: T2dString;
  OutFile: TFileStream;
  i, j: integer;
  s: string;
  Data: Pointer;

begin //Has been Synchronised
  if not (Sender is TSingleRunThread) then
    raise Exception.Create('Wrong Sender');

  ThrdObj := Sender as TSingleRunThread;
  ResultArray := ThrdObj.RtnArray;
  s := ThrdObj.DbQuery;
  MmoResults.Clear;
  MmoResults.Lines.Add('Single Thread Return');
  MmoResults.Lines.Add(S);
  MmoResults.Lines.Add('');
  if Length(ResultArray) < 1 then
    MmoResults.Lines.Add('Error Result');


  for i := 0 to Length(ResultArray) - 1 do
  begin
    s := '"';
    for j := 0 to Length(ResultArray[i]) - 1 do
      s := s + ResultArray[i, j] + '","';
    SetLength(s, Length(s) - 2);
    MmoResults.Lines.Add(s);
  end;
  MmoResults.Lines.Add('');
  MmoResults.Lines.Add('Single Thread Return');
end;


procedure TForm1.ServerObjectReturn(AServerObj: TSrverTaskObj);
var
  ResultArray: T2dString;
  OutFile: TFileStream;
  i, j: integer;
  s: string;

begin
  MmoResults.Clear;
  if AServerObj = nil then Exit;

  try
    ResultArray := AServerObj.Results;
    s := AServerObj.SqlCommand;
    MmoResults.Clear;
    MmoResults.Lines.Add('Server Thread Return');
    MmoResults.Lines.Add(S);
    MmoResults.Lines.Add('');
    if Length(ResultArray) < 1 then
      MmoResults.Lines.Add('Error Result');


    for i := 0 to Length(ResultArray) - 1 do
    begin
      s := '"';
      for j := 0 to Length(ResultArray[i]) - 1 do
        s := s + ResultArray[i, j] + '","';
      SetLength(s, Length(s) - 2);
      MmoResults.Lines.Add(s);
    end;
    MmoResults.Lines.Add('');
    MmoResults.Lines.Add('Message Thread Return');
  finally
    AServerObj.Free;
  end;

end;


procedure TForm1.SynchObjectReturn;
var
  ResultArray: T2dString;
  OutFile: TFileStream;
  i, j: integer;
  s: string;

begin
  MmoResults.Clear;
  If FSyncThread = nil then Exit;
  try
    ResultArray := FSyncThread.NxtAction.Results;
    s := FSyncThread.NxtAction.SqlCommand;
    MmoResults.Clear;
    MmoResults.Lines.Add('Synchronized Thread Return');
    MmoResults.Lines.Add(S);
    MmoResults.Lines.Add('');
    if Length(ResultArray) < 1 then
      MmoResults.Lines.Add('Error Result');


    for i := 0 to Length(ResultArray) - 1 do
    begin
      s := '"';
      for j := 0 to Length(ResultArray[i]) - 1 do
        s := s + ResultArray[i, j] + '","';
      SetLength(s, Length(s) - 2);
      MmoResults.Lines.Add(s);
    end;
    MmoResults.Lines.Add('');
    MmoResults.Lines.Add('Synchronized Thread Return');
  Except //You can handle exceptions but not let them escape
  End;
end;

procedure TForm1.BtnSyncRtnClick(Sender: TObject);
var
  i: integer;
  NxtTask: TSrverTaskObj;
begin
  if FSyncThread = nil then
   Begin
    FSyncThread := TSyncRtnThread.Create;
    FSyncThread.SychReturn:=SynchObjectReturn;
   end;
  for i := 1 to 20 do
  begin
    NxtTask := TSrverTaskObj.Create;
    NxtTask.SqlCommand := 'Select * from Employee Where Emp_no<' + intToStr(i);
    NxtTask.FmHandle := Handle;
    FSyncThread.Push(NxtTask);
  end;
end;

end.

